<?php $__env->startSection('title', 'Home Hero Section'); ?>
<?php $__env->startSection('page_title', 'Home Hero CMS'); ?>

<?php $__env->startSection('content'); ?>
<form action="<?php echo e(route('admin.pages.home.hero.update')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 30px;">
        <!-- Left: Main Content -->
        <div class="card">
            <div class="card-header">
                <h2>Hero Content</h2>
            </div>
            <div style="padding: 2rem;">
                <div class="form-group">
                    <label>Small Tagline</label>
                    <input type="text" name="hero[tag]" class="form-control" value="<?php echo e($hero->tag); ?>" placeholder="e.g. WELLNESS STARTS HERE">
                </div>

                <div class="form-group">
                    <label>Main Heading</label>
                    <input type="text" name="hero[heading]" class="form-control" value="<?php echo e($hero->heading); ?>" placeholder="Main catchy title">
                </div>

                <div class="form-group">
                    <label>Paragraph Text</label>
                    <textarea name="hero[paragraph]" class="form-control" rows="4" placeholder="Brief intro text..."><?php echo e($hero->paragraph); ?></textarea>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div class="form-group">
                        <label>Button 1 Text</label>
                        <input type="text" name="hero[btn1_text]" class="form-control" value="<?php echo e($hero->btn1_text); ?>">
                    </div>
                    <div class="form-group">
                        <label>Button 1 URL</label>
                        <input type="text" name="hero[btn1_url]" class="form-control" value="<?php echo e($hero->btn1_url); ?>">
                    </div>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div class="form-group">
                        <label>Button 2 Text</label>
                        <input type="text" name="hero[btn2_text]" class="form-control" value="<?php echo e($hero->btn2_text); ?>">
                    </div>
                    <div class="form-group">
                        <label>Button 2 URL</label>
                        <input type="text" name="hero[btn2_url]" class="form-control" value="<?php echo e($hero->btn2_url); ?>">
                    </div>
                </div>
            </div>
        </div>

        <!-- Right: Background Image & Save -->
        <div style="display: flex; flex-direction: column; gap: 25px;">
            <div class="card">
                <div class="card-header">
                    <h2>Background Image</h2>
                </div>
                <div style="padding: 2rem; text-align: center;">
                    <div style="margin-bottom: 20px; border: 2px dashed #eee; border-radius: 12px; padding: 10px; background: #fafafa;">
                        <img id="heroBgPreview" src="<?php echo e($hero->bg_image ? asset($hero->bg_image) : 'https://placehold.co/600x400'); ?>" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px;">
                    </div>
                    <input type="hidden" name="hero[bg_image]" id="heroBgInput" value="<?php echo e($hero->bg_image); ?>">
                    <button type="button" class="btn btn-secondary w-100" onclick="openCMSPicker('heroBgInput', 'heroBgPreview')">
                        <i class="fas fa-image"></i> Select Background
                    </button>
                    <p style="font-size: 0.75rem; color: #94a3b8; margin-top: 10px;">Recommended: 1920x1080px</p>
                </div>
            </div>

            <div class="card" style="background: var(--primary-red); color: white;">
                <div style="padding: 2rem; text-align: center;">
                    <i class="fas fa-save fa-3x" style="margin-bottom: 1rem; opacity: 0.8;"></i>
                    <h3 style="margin-bottom: 1.5rem;">Save Changes</h3>
                    <button type="submit" class="btn btn-primary" style="background: white; color: var(--primary-red); width: 100%; font-weight: 700;">
                        PUBLISH UPDATES
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Features Tags -->
    <div class="card" style="margin-top: 30px;">
        <div class="card-header">
            <h2>Bottom Feature Tags (4 Slots)</h2>
        </div>
        <div style="padding: 2rem; display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px;">
            <?php $__currentLoopData = $hero->bottom_tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div style="padding: 1.5rem; background: #f8fafc; border-radius: 15px; border: 1px solid #eef2f7;">
                <div class="form-group">
                    <label>Icon Class (FA)</label>
                    <input type="text" name="hero[bottom_tags][<?php echo e($index); ?>][icon]" class="form-control" value="<?php echo e($tag->icon); ?>" placeholder="fas fa-check">
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                    <label>Tag Name</label>
                    <input type="text" name="hero[bottom_tags][<?php echo e($index); ?>][name]" class="form-control" value="<?php echo e($tag->name); ?>">
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Projects\Planters\back\resources\views/admin/pages/home-hero.blade.php ENDPATH**/ ?>