<?php $__env->startSection('title', 'Edit Product'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Edit Product: <?php echo e($product->title); ?></h2>
        <a href="<?php echo e(route('admin.products.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
    </div>

    <?php if($errors->any()): ?>
    <div style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        <ul style="margin:0;">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.products.update', $product->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div style="display: grid; grid-template-columns: 2.2fr 1fr; gap: 2.5rem;">
            <!-- Left Side -->
            <div>
                <div class="form-group">
                    <label>Product Title</label>
                    <input type="text" name="title" id="prod_title" value="<?php echo e(old('title', $product->title)); ?>" required>
                </div>

                <div class="form-group">
                    <label>Slug</label>
                    <input type="text" name="slug" id="prod_slug" value="<?php echo e(old('slug', $product->slug)); ?>">
                </div>

                <div class="form-group">
                    <label>Thumbnail Image</label>
                    <div id="thumb_box" style="width: 100%; height: 200px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; flex-direction: column; align-items:center; justify-content:center; overflow:hidden; cursor: pointer; transition: 0.3s;" onclick="openPicker('single', 'thumb_id', 'thumb_box')">
                        <?php if($product->thumbnail): ?>
                        <img src="<?php echo e(asset(ltrim($product->thumbnail->path ?? '', '/'))); ?>" style="width:100%; height:100%; object-fit:cover;" onerror="this.onerror=null; this.style.display='none'; this.nextElementSibling.style.display='block';">
                        <span style="display:none; color: #718096; font-size: 0.9rem;">Click to select thumbnail</span>
                        <?php else: ?>
                        <i class="fas fa-cloud-upload-alt" style="font-size: 2.5rem; color: #cbd5e0; margin-bottom: 10px;"></i>
                        <span style="color: #718096; font-size: 0.9rem;">Click to select thumbnail</span>
                        <?php endif; ?>
                    </div>
                    <input type="hidden" name="thumbnail_id" id="thumb_id" value="<?php echo e($product->thumbnail_id); ?>">
                </div>

                <div class="form-group">
                    <label>Product Gallery</label>
                    <div id="gallery_box" style="width: 100%; min-height: 150px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; flex-wrap: wrap; gap: 10px; padding: 15px; cursor: pointer;" onclick="openPicker('multiple', 'gallery_ids', 'gallery_box')">
                        <?php $__empty_1 = true; $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="preview-item" style="width: 100px; height: 100px; border-radius: 8px; overflow: hidden; border: 1px solid #ddd;">
                            <img src="<?php echo e(asset(ltrim($img->path ?? '', '/'))); ?>" style="width:100%; height:100%; object-fit:cover;">
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div style="width: 100%; text-align: center; color: #718096; display: flex; flex-direction: column; align-items: center; justify-content: center;" id="gallery_placeholder">
                            <i class="fas fa-images" style="font-size: 2.5rem; color: #cbd5e0; margin-bottom: 10px;"></i>
                            <span style="font-size: 0.9rem;">Click to select multiple gallery images</span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php
                    $galleryIds = $product->images->pluck('id')->toArray();
                    ?>
                    <input type="hidden" name="gallery_ids" id="gallery_ids" value="<?php echo e(json_encode($galleryIds)); ?>">
                </div>

                <div class="form-group">
                    <label>Short Description</label>
                    <textarea name="short_description" style="min-height: 100px;"><?php echo e(old('short_description', $product->short_description)); ?></textarea>
                </div>

                <div class="form-group">
                    <label>Long Description</label>
                    <textarea name="long_description" id="editor"><?php echo e(old('long_description', $product->long_description)); ?></textarea>
                </div>

                <div class="form-group">
                    <label>How to Use</label>
                    <textarea name="how_to_use" style="min-height: 120px;"><?php echo e(old('how_to_use', $product->how_to_use)); ?></textarea>
                </div>
            </div>

            <!-- Right Side (Sidebar) -->
            <div>
                <div class="card" style="padding: 1.5rem; border-radius: 15px; margin-bottom: 2rem; position: sticky; top: 20px;">
                    <div class="form-group">
                        <label>Category</label>
                        <select name="category_id" required>
                            <option value="">Select Category</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id', $product->category_id) == $category->id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                        <div class="form-group">
                            <label>Base Price (PKR)</label>
                            <input type="number" step="0.01" name="price" value="<?php echo e(old('price', $product->price)); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Discount (PKR)</label>
                            <input type="number" step="0.01" name="discount_price" value="<?php echo e(old('discount_price', $product->discount_price)); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" id="prod_status">
                            <option value="in_stock" <?php echo e(old('status', $product->status) == 'in_stock' ? 'selected' : ''); ?>>In Stock</option>
                            <option value="out_of_stock" <?php echo e(old('status', $product->status) == 'out_of_stock' ? 'selected' : ''); ?>>Out of Stock</option>
                        </select>
                    </div>

                    <div class="form-group" id="stock_field" style="<?php echo e($product->status == 'out_of_stock' ? 'display:none;' : ''); ?>">
                        <label>Stock Quantity</label>
                        <input type="number" name="stock_quantity" value="<?php echo e(old('stock_quantity', $product->stock_quantity)); ?>">
                    </div>

                    <div class="form-group">
                        <label>Tags</label>
                        <div style="max-height: 250px; overflow-y: auto; padding: 12px; background: #fff; border-radius: 10px; border: 2px solid #edf2f7;">
                            <?php $selectedTags = $product->tags->pluck('id')->toArray(); ?>
                            <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label style="display:flex; align-items:center; gap: 10px; margin-bottom: 8px; cursor:pointer; font-size: 0.9rem;">
                                <input type="checkbox" name="tag_ids[]" value="<?php echo e($tag->id); ?>" style="width: auto;" <?php echo e(in_array($tag->id, $selectedTags) ? 'checked' : ''); ?>>
                                <i class="<?php echo e($tag->icon); ?>" style="color: #4a5568;"></i> <?php echo e($tag->name); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary" style="width:100%; padding: 1rem; margin-top: 1rem;">
                        <i class="fas fa-save"></i> Update Product
                    </button>
                    <a href="<?php echo e(route('admin.products.index')); ?>" class="btn btn-secondary" style="width:100%; margin-top: 0.5rem; justify-content:center;">Cancel</a>
                </div>
            </div>
        </div>
    </form>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });

    document.getElementById('prod_status').addEventListener('change', function() {
        const stockField = document.getElementById('stock_field');
        if (this.value === 'in_stock') {
            stockField.style.display = 'block';
        } else {
            stockField.style.display = 'none';
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Projects\Planters\back\resources\views/admin/products/edit.blade.php ENDPATH**/ ?>