<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Dashboard'); ?> - TPL Pest Control</title>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #c41e3a;
            --primary-red: #c41e3a;
            --primary-dark: #9e1830;
            --dark-red: #9e1830;
            --primary-light: #fef2f2;
            --sidebar-bg: #0f172a;
            --sidebar-text: #94a3b8;
            --sidebar-text-active: #ffffff;
            --sidebar-hover: rgba(255,255,255,0.06);
            --sidebar-width: 260px;
            --header-height: 64px;
            --surface: #ffffff;
            --bg: #f1f5f9;
            --border: #e2e8f0;
            --text: #1e293b;
            --text-muted: #64748b;
            --radius: 12px;
            --radius-lg: 16px;
            --shadow-sm: 0 1px 2px rgba(0,0,0,0.04);
            --shadow: 0 4px 6px -1px rgba(0,0,0,0.06), 0 2px 4px -2px rgba(0,0,0,0.04);
            --shadow-lg: 0 10px 25px -5px rgba(0,0,0,0.08), 0 4px 10px -5px rgba(0,0,0,0.04);
            --input-padding: 0.75rem 1rem;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Open Sans', sans-serif;
        }

        html {
            font-size: 15px;
        }

        body {
            background-color: var(--bg);
            color: var(--text);
            line-height: 1.6;
            -webkit-font-smoothing: antialiased;
        }

        .sidebar::-webkit-scrollbar { width: 6px; }
        .sidebar::-webkit-scrollbar-track { background: var(--sidebar-bg); }
        .sidebar::-webkit-scrollbar-thumb { background: rgba(255,255,255,0.15); border-radius: 10px; }
        .sidebar::-webkit-scrollbar-thumb:hover { background: rgba(255,255,255,0.25); }

        .sidebar {
            width: var(--sidebar-width);
            height: 100vh;
            background: var(--sidebar-bg);
            position: fixed;
            left: 0;
            top: 0;
            color: var(--sidebar-text);
            overflow-y: auto;
            z-index: 1000;
            transition: width 0.25s ease;
            display: flex;
            flex-direction: column;
        }

        .sidebar-header {
            min-height: var(--header-height);
            display: flex;
            align-items: center;
            padding: 0 1.25rem;
            border-bottom: 1px solid rgba(255,255,255,0.06);
        }

        .sidebar-header img {
            max-width: 140px;
            max-height: 40px;
            object-fit: contain;
        }

        .sidebar-menu {
            padding: 1rem 0 0.5rem;
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .sidebar .menu-item.sidebar-logout {
            margin-top: auto;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 0.7rem 1.25rem;
            color: var(--sidebar-text);
            text-decoration: none;
            transition: background 0.2s, color 0.2s;
            font-size: 0.9rem;
            font-weight: 500;
            margin: 2px 0.75rem;
            border-radius: var(--radius);
        }

        .menu-item i {
            margin-right: 12px;
            width: 20px;
            text-align: center;
            font-size: 1rem;
            opacity: 0.9;
        }

        .menu-item:hover {
            background: var(--sidebar-hover);
            color: var(--sidebar-text-active);
        }

        .menu-item.active {
            background: rgba(196, 30, 58, 0.15);
            color: #fca5a5;
            border-left: none;
        }

        .menu-item.active i { color: var(--primary); }

        .main-content {
            margin-left: var(--sidebar-width);
            padding: 1.5rem 1.75rem;
            min-height: 100vh;
        }

        .top-header {
            height: var(--header-height);
            background: var(--surface);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 1.75rem;
            box-shadow: var(--shadow-sm);
            margin: -1.5rem -1.75rem 1.5rem -1.75rem;
            border-bottom: 1px solid var(--border);
        }

        .header-left { display: flex; align-items: center; gap: 1rem; }
        .header-right { display: flex; align-items: center; gap: 1.25rem; }

        .toggle-sidebar {
            cursor: pointer;
            font-size: 1.15rem;
            color: var(--text-muted);
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: var(--radius);
            transition: background 0.2s, color 0.2s;
        }
        .toggle-sidebar:hover { background: var(--bg); color: var(--text); }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            cursor: pointer;
            padding: 0.4rem 0.6rem;
            border-radius: var(--radius);
            transition: background 0.2s;
        }
        .user-profile:hover { background: var(--bg); }

        .user-profile span {
            font-weight: 600;
            color: var(--text);
            font-size: 0.9rem;
        }

        .user-profile img {
            width: 36px;
            height: 36px;
            border-radius: 10px;
        }

        .nav-icon {
            font-size: 1.1rem;
            color: var(--text-muted);
            cursor: pointer;
            position: relative;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: var(--radius);
            transition: color 0.2s, background 0.2s;
        }
        .nav-icon:hover { color: var(--text); background: var(--bg); }

        .nav-icon .badge-count {
            position: absolute;
            top: 4px;
            right: 4px;
            background: var(--primary);
            color: white;
            font-size: 0.65rem;
            font-weight: 700;
            min-width: 16px;
            height: 16px;
            padding: 0 4px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .profile-dropdown { position: relative; }

        .dropdown-menu {
            position: absolute;
            top: calc(100% + 8px);
            right: 0;
            background: var(--surface);
            box-shadow: var(--shadow-lg);
            border-radius: var(--radius-lg);
            min-width: 200px;
            display: none;
            z-index: 1001;
            padding: 0.5rem;
            border: 1px solid var(--border);
        }
        .dropdown-menu.show { display: block; }

        .dropdown-item {
            padding: 0.65rem 1rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            color: var(--text);
            text-decoration: none;
            transition: background 0.2s;
            font-size: 0.9rem;
            font-weight: 500;
            border-radius: 8px;
        }
        .dropdown-item:hover { background: var(--primary-light); color: var(--primary); }

        .sidebar.collapsed { width: 72px; }
        .sidebar.collapsed .sidebar-header img,
        .sidebar.collapsed .menu-item span,
        .sidebar.collapsed .menu-item .arrow { display: none; }
        .sidebar.collapsed .menu-item { justify-content: center; margin-left: 0; margin-right: 0; padding: 0.75rem; }
        .sidebar.collapsed + .main-content { margin-left: 72px; }

        .has-submenu { position: relative; }
        .submenu { display: none; list-style: none; padding: 0.25rem 0 0.25rem 0; margin-left: 0.75rem; border-left: 1px solid rgba(255,255,255,0.08); }
        .submenu .menu-item { padding-left: 2rem; font-size: 0.85rem; margin: 2px 0.5rem; }
        .menu-item .arrow { margin-left: auto; transition: transform 0.25s; font-size: 0.7rem; opacity: 0.7; }
        .menu-item.open .arrow { transform: rotate(90deg); }
        .has-submenu > .menu-item { cursor: pointer; }

        .card {
            background: var(--surface);
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow);
            margin-bottom: 1.75rem;
            padding: 1.5rem 1.75rem;
            border: 1px solid var(--border);
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.25rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border);
        }
        .card-header h2 {
            font-size: 1.15rem;
            font-weight: 700;
            color: var(--text);
        }

        .table-responsive { overflow-x: auto; margin-top: 0.5rem; }

        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 6px;
        }
        table th {
            text-align: left;
            padding: 0.85rem 1rem;
            color: var(--text-muted);
            font-weight: 600;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }
        table td {
            padding: 1rem;
            background: var(--surface);
            vertical-align: middle;
            color: var(--text);
            font-size: 0.9rem;
            border: 1px solid var(--border);
            border-left: none;
        }
        table tr td:first-child {
            border-left: 1px solid var(--border);
            border-top-left-radius: var(--radius);
            border-bottom-left-radius: var(--radius);
        }
        table tr td:last-child {
            border-right: 1px solid var(--border);
            border-top-right-radius: var(--radius);
            border-bottom-right-radius: var(--radius);
        }
        table tbody tr:hover td { background: #f8fafc; }

        .form-group { margin-bottom: 1.25rem; }
        .form-label {
            display: block;
            font-weight: 600;
            margin-bottom: 0.4rem;
            color: var(--text);
            font-size: 0.9rem;
        }

        .form-control, input[type="text"], input[type="number"], input[type="email"], input[type="password"], input[type="url"], input[type="date"], select, textarea {
            width: 100%;
            padding: var(--input-padding);
            border: 1.5px solid var(--border);
            border-radius: var(--radius);
            transition: border-color 0.2s, box-shadow 0.2s;
            font-size: 0.95rem;
            font-family: 'Open Sans', sans-serif;
            color: var(--text);
            background: var(--surface);
        }
        .form-control:focus, input:focus, select:focus, textarea:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(196, 30, 58, 0.12);
            outline: none;
        }

        .btn {
            padding: 0.65rem 1.25rem;
            border-radius: var(--radius);
            font-weight: 600;
            font-family: 'Open Sans', sans-serif;
            cursor: pointer;
            border: none;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            justify-content: center;
            font-size: 0.9rem;
        }
        .btn-primary {
            background: var(--primary);
            color: white;
            box-shadow: 0 2px 8px rgba(196, 30, 58, 0.25);
        }
        .btn-primary:hover {
            background: var(--primary-dark);
            box-shadow: 0 4px 12px rgba(196, 30, 58, 0.35);
            color: white;
        }
        .btn-secondary {
            background: #f1f5f9;
            color: var(--text);
        }
        .btn-secondary:hover { background: #e2e8f0; color: var(--text); }
        .btn-sm { padding: 0.4rem 0.9rem; font-size: 0.8rem; }

        .action-btn {
            width: 34px;
            height: 34px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            color: white;
            cursor: pointer;
            transition: all 0.2s;
            border: none;
            font-size: 0.85rem;
            text-decoration: none;
        }
        .btn-edit { background: #475569; }
        .btn-edit:hover { background: #334155; transform: scale(1.05); }
        .btn-delete { background: var(--primary); }
        .btn-delete:hover { background: var(--primary-dark); transform: scale(1.05); }
        .btn-move { background: #6366f1; }
        .btn-move:hover { background: #4f46e5; transform: scale(1.05); }
        .btn-view { background: #059669; }
        .btn-view:hover { background: #047857; transform: scale(1.05); }

        .modal {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(15, 23, 42, 0.5);
            backdrop-filter: blur(6px);
            z-index: 10000;
            align-items: center;
            justify-content: center;
            padding: 1.5rem;
        }
        .modal-content {
            background: var(--surface);
            width: 100%;
            max-width: 1100px;
            border-radius: var(--radius-lg);
            transform: scale(0.96);
            opacity: 0;
            transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
            max-height: 90vh;
            display: flex;
            flex-direction: column;
            overflow: hidden;
            box-shadow: var(--shadow-lg);
            border: 1px solid var(--border);
        }
        .modal.show { display: flex; }
        .modal.show .modal-content { transform: scale(1); opacity: 1; }
        .modal-header {
            padding: 1.25rem 1.75rem;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .modal-footer {
            padding: 1.25rem 1.75rem;
            border-top: 1px solid var(--border);
            display: flex;
            justify-content: flex-end;
            gap: 0.75rem;
        }

        .badge {
            padding: 0.35rem 0.65rem;
            border-radius: 8px;
            font-size: 0.75rem;
            font-weight: 700;
            display: inline-block;
        }
        .badge-success { background: #ecfdf5; color: #059669; }
        .badge-danger { background: #fef2f2; color: #dc2626; }
        .badge-warning { background: #fffbeb; color: #d97706; }
        .badge-info { background: #f0f9ff; color: #0284c7; }

        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 0.5rem;
            margin-top: 1.5rem;
            flex-wrap: wrap;
        }
        .pagination .page-item, .pagination .page-link, .pagination button, .pagination a, .pagination span {
            min-width: 38px;
            height: 38px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0 10px;
            border-radius: var(--radius);
            background: var(--surface);
            color: var(--text);
            text-decoration: none;
            font-weight: 600;
            font-size: 0.875rem;
            border: 1px solid var(--border);
            transition: all 0.2s;
            cursor: pointer;
            margin: 0;
        }
        .pagination .active .page-link, .pagination .active, .pagination .current, .pagination button.active {
            background: var(--primary) !important;
            color: white !important;
            border-color: var(--primary) !important;
        }
        .pagination a:hover, .pagination .page-link:hover, .pagination button:hover:not(.active) {
            background: var(--primary-light);
            border-color: var(--primary);
            color: var(--primary);
        }
        .pagination .disabled, .pagination .gap { opacity: 0.5; cursor: not-allowed; }

        @media (max-width: 768px) {
            .sidebar {
                left: -260px;
                width: 260px;
                height: 100vh;
                top: 0;
            }
            .sidebar.mobile-open { left: 0; }
            .main-content { margin-left: 0 !important; padding-top: calc(var(--header-height) + 1rem); }
            .top-header { position: fixed; top: 0; left: 0; width: 100%; margin: 0 !important; z-index: 1001; }
        }
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <img src="<?php echo e(asset('logo.png')); ?>" style="width: 80%; height: 83%;">
        </div>
        <div class="sidebar-menu">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="menu-item <?php echo e(Request::is('admin/dashboard*') ? 'active' : ''); ?>">
                <i class="fas fa-th-large"></i> <span>Dashboard</span>
            </a>
            
            <div class="has-submenu">
                <div class="menu-item <?php echo e(Request::is('admin/pages*') ? 'active' : ''); ?>">
                    <i class="fas fa-file-alt"></i> <span>Pages</span>
                    <i class="fas fa-chevron-right arrow"></i>
                </div>
                <ul class="submenu" style="<?php echo e(Request::is('admin/pages*') ? 'display: block;' : ''); ?>">
                    <li><a href="<?php echo e(route('admin.pages.home.hero')); ?>" class="menu-item">Home Hero</a></li>
                    <li><a href="<?php echo e(route('admin.pages.home.banner')); ?>" class="menu-item">Home Banner</a></li>
                    <li><a href="<?php echo e(route('admin.pages.about')); ?>" class="menu-item">About Us</a></li>
                    <li><a href="<?php echo e(route('admin.pages.contact')); ?>" class="menu-item">Contact Us</a></li>
                    <li><a href="<?php echo e(route('admin.pages.footer')); ?>" class="menu-item">Footer</a></li>
                    <li><a href="<?php echo e(route('admin.pages.why-choose-us')); ?>" class="menu-item">Why Choose Us</a></li>
                </ul>
            </div>

            <div class="has-submenu">
                <div class="menu-item <?php echo e(Request::is('admin/products*') ? 'active' : ''); ?>">
                    <i class="fas fa-shopping-bag"></i> <span>Products</span>
                    <i class="fas fa-chevron-right arrow"></i>
                </div>
                <ul class="submenu" style="<?php echo e(Request::is('admin/products*') ? 'display: block;' : ''); ?>">
                    <li><a href="<?php echo e(route('admin.products.index')); ?>" class="menu-item">View Products</a></li>
                    <li><a href="<?php echo e(route('admin.products.create')); ?>" class="menu-item">Add Product</a></li>
                    <li><a href="<?php echo e(route('admin.categories.index')); ?>" class="menu-item">Categories</a></li>
                    <li><a href="<?php echo e(route('admin.tags.index')); ?>" class="menu-item">Tags</a></li>
                </ul>
            </div>

            <div class="has-submenu">
                <div class="menu-item <?php echo e(Request::is('admin/blogs*') ? 'active' : ''); ?>">
                    <i class="fas fa-blog"></i> <span>Blogs</span>
                    <i class="fas fa-chevron-right arrow"></i>
                </div>
                <ul class="submenu" style="<?php echo e(Request::is('admin/blogs*') ? 'display: block;' : ''); ?>">
                    <li><a href="<?php echo e(route('admin.blogs.index')); ?>" class="menu-item">View Blogs</a></li>
                    <li><a href="<?php echo e(route('admin.blogs.create')); ?>" class="menu-item">Add Blog</a></li>
                </ul>
            </div>
            <div class="has-submenu">
                <div class="menu-item <?php echo e(Request::is('admin/pest*') ? 'active' : ''); ?>">
                    <i class="fas fa-bug"></i> <span>Pest Control</span>
                    <i class="fas fa-chevron-right arrow"></i>
                </div>
                <ul class="submenu" style="<?php echo e(Request::is('admin/pest*') ? 'display: block;' : ''); ?>">
                    <li><a href="<?php echo e(route('admin.pest-categories.index')); ?>" class="menu-item">Categories</a></li>
                    <li><a href="<?php echo e(route('admin.pests.index')); ?>" class="menu-item">View Pests</a></li>
                </ul>
            </div>


            <div class="has-submenu">
                <div class="menu-item <?php echo e(Request::is('admin/service*') ? 'active' : ''); ?>">
                    <i class="fas fa-hand-holding-heart"></i> <span>Services</span>
                    <i class="fas fa-chevron-right arrow"></i>
                </div>
                <ul class="submenu" style="<?php echo e(Request::is('admin/service*') ? 'display: block;' : ''); ?>">
                    <li><a href="<?php echo e(route('admin.service-categories.index')); ?>" class="menu-item">Categories</a></li>
                    <li><a href="<?php echo e(route('admin.services.index')); ?>" class="menu-item">View Services</a></li>
                    <li><a href="<?php echo e(route('admin.service-areas.index')); ?>" class="menu-item">Service Areas</a></li>
                </ul>
            </div>

            <a href="<?php echo e(route('admin.images.index')); ?>" class="menu-item <?php echo e(Request::is('admin/images*') ? 'active' : ''); ?>">
                <i class="fas fa-photo-video"></i> <span>Images</span>
            </a>
            
            <a href="<?php echo e(route('admin.distributors.index')); ?>" class="menu-item <?php echo e(Request::is('admin/distributors*') ? 'active' : ''); ?>">
                <i class="fas fa-truck"></i> <span>Distributors</span>
            </a>

            <a href="<?php echo e(route('admin.registrations.index')); ?>" class="menu-item <?php echo e(Request::is('admin/registrations*') ? 'active' : ''); ?>">
                <i class="fas fa-id-card"></i> <span>Registrations</span>
            </a>

            <a href="<?php echo e(route('admin.testimonials.index')); ?>" class="menu-item <?php echo e(Request::is('admin/testimonials*') ? 'active' : ''); ?>">
                <i class="fas fa-star"></i> <span>Testimonials</span>
            </a>

            <a href="<?php echo e(route('admin.why-choose-us.index')); ?>" class="menu-item <?php echo e(Request::is('admin/why-choose-us*') ? 'active' : ''); ?>">
                <i class="fas fa-hand-holding-usd"></i> <span>Why Choose Us Cards</span>
            </a>

            <a href="<?php echo e(route('admin.social-media.index')); ?>" class="menu-item <?php echo e(Request::is('admin/social-media*') ? 'active' : ''); ?>">
                <i class="fas fa-share-alt"></i> <span>Social Media</span>
            </a>

            <a href="<?php echo e(route('admin.faqs.index')); ?>" class="menu-item <?php echo e(Request::is('admin/faqs*') ? 'active' : ''); ?>">
                <i class="fas fa-question-circle"></i> <span>FAQs</span>
            </a>

            <a href="<?php echo e(route('admin.orders.index')); ?>" class="menu-item <?php echo e(Request::is('admin/orders*') ? 'active' : ''); ?>">
                <i class="fas fa-shopping-cart"></i> <span>Orders</span>
            </a>

            <a href="<?php echo e(route('admin.reviews.index')); ?>" class="menu-item <?php echo e(Request::is('admin/reviews*') ? 'active' : ''); ?>">
                <i class="fas fa-comment-dots"></i> <span>Product Reviews</span>
            </a>

            <a href="<?php echo e(route('admin.page-seos.index')); ?>" class="menu-item <?php echo e(Request::is('admin/page-seos*') ? 'active' : ''); ?>">
                <i class="fas fa-search"></i> <span>Page SEO</span>
            </a>

            <a href="<?php echo e(route('admin.navbar-links.index')); ?>" class="menu-item <?php echo e(Request::is('admin/navbar-links*') ? 'active' : ''); ?>">
                <i class="fas fa-link"></i> <span>Navbar Links</span>
            </a>

            
            <a href="<?php echo e(route('admin.settings.index')); ?>" class="menu-item <?php echo e(Request::is('admin/settings*') ? 'active' : ''); ?>">
                <i class="fas fa-cog"></i> <span>Settings</span>
            </a>

            <form action="<?php echo e(route('logout')); ?>" method="POST" id="sidebar-logout-form" style="display: none;"><?php echo csrf_field(); ?></form>
            <a href="javascript:void(0)" onclick="document.getElementById('sidebar-logout-form').submit();" class="menu-item sidebar-logout" style="color: #fca5a5; background: rgba(196, 30, 58, 0.12);">
                <i class="fas fa-sign-out-alt"></i> <span>Logout</span>
            </a>
        </div>
    </div>

    <div class="main-content">
        <div class="top-header">
            <div class="header-left">
                <i class="fas fa-bars toggle-sidebar" onclick="toggleSidebar()"></i>
                <h2 style="font-size: 1.1rem; font-weight: 700; color: var(--text);"><?php echo $__env->yieldContent('page_title', 'Admin Dashboard'); ?></h2>
            </div>
            
            <div class="header-right">
                <div class="nav-icon">
                    <i class="far fa-bell"></i>
                    <span class="badge-count">3</span>
                </div>
                
                <div class="profile-dropdown">
                    <div class="user-profile" onclick="toggleProfileDropdown()">
                        <span><?php echo e(Auth::user()->name); ?></span>
                        <img src="https://ui-avatars.com/api/?name=<?php echo e(Auth::user()->name); ?>&background=d90404&color=fff" style="width: 32px; height: 32px; border-radius: 50%;">
                    </div>
                    <div class="dropdown-menu" id="profileDropdown">
                        <a href="<?php echo e(route('admin.profile.password')); ?>" class="dropdown-item">
                            <i class="fas fa-key"></i> Change Password
                        </a>
                        <hr style="border: 0; border-top: 1px solid #f1f5f9; margin: 5px 0;">
                        <form action="<?php echo e(route('logout')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="dropdown-item" style="width: 100%; border: none; background: none; cursor: pointer;">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <?php echo $__env->make('admin.partials.picker-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function openCMSPicker(inputId, previewId) {
            if (typeof openPicker === 'function') {
                openPicker('single', inputId, previewId, (selected) => {
                    const img = selected[0];
                    document.getElementById(inputId).value = img.id; // Store ID for foreign key
                    const preview = document.getElementById(previewId);
                    if (preview.tagName === 'IMG') {
                        const base = (typeof window.ADMIN_BASE_URL !== 'undefined' ? window.ADMIN_BASE_URL : '') || '';
                        const path = (img.path || '').replace(/^\/+/, '');
                        const src = path ? (base ? base + '/' + path : '/' + path) : '';
                        preview.src = src;
                        preview.style.display = 'block';
                    } else {
                        const base = (typeof window.ADMIN_BASE_URL !== 'undefined' ? window.ADMIN_BASE_URL : '') || '';
                        const path = (img.path || '').replace(/^\/+/, '');
                        const src = path ? (base ? base + '/' + path : '/' + path) : '';
                        preview.innerHTML = `<img src="${src}" style="width:100%; height:100%; object-fit:cover; border-radius:8px;">`;
                    }
                });
            }
        }
        function toggleSidebar() {
            const sidebar = document.querySelector('.sidebar');
            if (window.innerWidth <= 768) {
                sidebar.classList.toggle('mobile-open');
            } else {
                sidebar.classList.toggle('collapsed');
            }
        }

        function toggleProfileDropdown() {
            document.getElementById('profileDropdown').classList.toggle('show');
        }

        window.onclick = function(event) {
            if (!event.target.closest('.profile-dropdown')) {
                const dropdown = document.getElementById('profileDropdown');
                if(dropdown) dropdown.classList.remove('show');
            }
        }

        // Submenu Toggle
        document.querySelectorAll('.has-submenu > .menu-item').forEach(item => {
            item.addEventListener('click', function(e) {
                this.classList.toggle('open');
                const submenu = this.nextElementSibling;
                if(submenu) submenu.style.display = submenu.style.display === 'block' ? 'none' : 'block';
            });
        });

        // Close sidebar on mobile when a link is clicked
        document.querySelectorAll('.sidebar-menu a:not(.has-submenu > .menu-item)').forEach(link => {
            link.addEventListener('click', () => {
                if (window.innerWidth <= 768) {
                    document.querySelector('.sidebar').classList.remove('mobile-open');
                }
            });
        });

        function openModal(id) {
            const modal = document.getElementById(id);
            if (modal) {
                modal.style.display = 'flex';
                setTimeout(() => modal.classList.add('show'), 10);
            }
        }

        function closeModal(id) {
            const modal = document.getElementById(id);
            if (modal) {
                modal.classList.remove('show');
                setTimeout(() => modal.style.display = 'none', 300);
            }
        }
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html><?php /**PATH D:\Projects\Planters\back\resources\views/layouts/admin.blade.php ENDPATH**/ ?>