<!DOCTYPE html>
<html>

<head>
    <title>Order Confirmation</title>
</head>

<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;">
    <h1 style="color: #2d3748;">Order Confirmation</h1>
    <p>Hi {{ $order->customer_name }},</p>
    <p>Thank you for your order! We've received your order <strong>{{ $order->order_number }}</strong> and it's being processed.</p>

    <h3>Order Summary</h3>
    <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
            <tr style="background: #f8fafc;">
                <th style="padding: 10px; border: 1px solid #edf2f7; text-align: left;">Item</th>
                <th style="padding: 10px; border: 1px solid #edf2f7; text-align: center;">Qty</th>
                <th style="padding: 10px; border: 1px solid #edf2f7; text-align: right;">Price</th>
            </tr>
        </thead>
        <tbody>
            @foreach($order->items as $item)
            <tr>
                <td style="padding: 10px; border: 1px solid #edf2f7;">{{ $item->product->title }}</td>
                <td style="padding: 10px; border: 1px solid #edf2f7; text-align: center;">{{ $item->quantity }}</td>
                <td style="padding: 10px; border: 1px solid #edf2f7; text-align: right;">PKR {{ number_format($item->price, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="2" style="padding: 10px; text-align: right; font-weight: bold;">Total</td>
                <td style="padding: 10px; text-align: right; font-weight: bold;">PKR {{ number_format($order->final_amount, 2) }}</td>
            </tr>
        </tfoot>
    </table>

    <p><strong>Shipping Address:</strong><br>{{ $order->shipping_address }}</p>

    <p>If you have any questions, please reply to this email.</p>

    <p>Best regards,<br>Planters Team</p>
</body>

</html>