@extends('layouts.admin')

@section('title', 'Testimonials')
@section('page_title', 'Manage Testimonials')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Testimonials List</h2>
        <a href="{{ route('admin.testimonials.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add Testimonial
        </a>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Client</th>
                    <th>Message</th>
                    <th>Rating</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($testimonials as $item)
                <tr>
                    <td>
                        <div style="display: flex; align-items: center; gap: 12px;">
                            <img src="{{ $item->imageFile ? asset($item->imageFile->path) : 'https://ui-avatars.com/api/?name='.$item->client_name }}" style="width: 45px; height: 45px; border-radius: 50%; border: 1px solid #eee;">
                            <div>
                                <div style="font-weight: 600;">{{ $item->client_name }}</div>
                                <div style="font-size: 0.75rem; color: #64748b;">{{ $item->designation }}</div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <p style="max-width: 400px; font-size: 0.85rem; color: #64748b; margin: 0;">{{ Str::limit($item->message, 100) }}</p>
                    </td>
                    <td>
                        <div style="color: #fbbf24;">
                            @for($i=1; $i<=5; $i++)
                                <i class="{{ $i <= $item->rating ? 'fas' : 'far' }} fa-star"></i>
                                @endfor
                        </div>
                    </td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.testimonials.edit', $item) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.testimonials.destroy', $item) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" style="text-align: center; padding: 3rem;">No testimonials found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div style="margin-top: 1.5rem;">
        {{ $testimonials->links() }}
    </div>
</div>
@endsection