@extends('layouts.admin')

@section('title', 'System Settings')

@section('content')
<div style="max-width: 800px; margin: 0 auto;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h2 style="font-size: 1.5rem; color: #1a202c;">Settings</h2>
    </div>

    @if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        {{ session('success') }}
    </div>
    @endif

    <form action="{{ route('admin.settings.store') }}" method="POST">
        @csrf

        <!-- SMTP Settings -->
        <div class="card" style="padding: 2rem; margin-bottom: 2rem;">
            <h3 style="font-size: 1.1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">
                <i class="fas fa-envelope" style="margin-right: 10px; color: #4299e1;"></i> SMTP Configuration
            </h3>
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
                <div class="form-group">
                    <label>MAIL_HOST</label>
                    <input type="text" name="MAIL_HOST" value="{{ $settings['MAIL_HOST'] ?? '' }}" style="width: 100%;">
                </div>
                <div class="form-group">
                    <label>MAIL_PORT</label>
                    <input type="text" name="MAIL_PORT" value="{{ $settings['MAIL_PORT'] ?? '' }}" style="width: 100%;">
                </div>
                <div class="form-group">
                    <label>MAIL_USERNAME</label>
                    <input type="text" name="MAIL_USERNAME" value="{{ $settings['MAIL_USERNAME'] ?? '' }}" style="width: 100%;">
                </div>
                <div class="form-group">
                    <label>MAIL_PASSWORD</label>
                    <input type="password" name="MAIL_PASSWORD" value="{{ $settings['MAIL_PASSWORD'] ?? '' }}" style="width: 100%;">
                </div>
                <div class="form-group">
                    <label>MAIL_ENCRYPTION</label>
                    <input type="text" name="MAIL_ENCRYPTION" value="{{ $settings['MAIL_ENCRYPTION'] ?? 'tls' }}" style="width: 100%;">
                </div>
                <div class="form-group">
                    <label>MAIL_FROM_ADDRESS</label>
                    <input type="email" name="MAIL_FROM_ADDRESS" value="{{ $settings['MAIL_FROM_ADDRESS'] ?? '' }}" style="width: 100%;">
                </div>
            </div>
        </div>

        <!-- Stripe Settings -->
        <div class="card" style="padding: 2rem; margin-bottom: 2rem;">
            <h3 style="font-size: 1.1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">
                <i class="fab fa-stripe" style="margin-right: 10px; color: #6772e5; font-size: 1.5rem;"></i> Stripe Configuration
            </h3>
            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>Stripe Publishable Key</label>
                <input type="text" name="STRIPE_KEY" value="{{ $settings['STRIPE_KEY'] ?? '' }}" style="width: 100%;">
            </div>
            <div class="form-group">
                <label>Stripe Secret Key</label>
                <input type="password" name="STRIPE_SECRET" value="{{ $settings['STRIPE_SECRET'] ?? '' }}" style="width: 100%;">
            </div>
        </div>

        <!-- Navbar Settings -->
        <div class="card" style="padding: 2rem; margin-bottom: 2rem;">
            <h3 style="font-size: 1.1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">
                <i class="fas fa-bars" style="margin-right: 10px; color: #48bb78;"></i> Navbar Configuration
            </h3>
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
                <div class="form-group">
                    <label>Navbar Logo</label>
                    <div style="margin-bottom: 10px; border: 1px solid #e2e8f0; border-radius: 8px; padding: 5px; background: #fff; text-align: center; height: 100px; display: flex; align-items: center; justify-content: center;">
                        <img id="navbarLogoPreview" src="{{ isset($settings['navbar_logo']) ? asset($settings['navbar_logo']) : 'https://placehold.co/200x50' }}" style="max-width: 100%; max-height: 100%; object-fit: contain;">
                    </div>
                    <input type="hidden" name="navbar_logo" id="navbarLogoInput" value="{{ $settings['navbar_logo'] ?? '' }}">
                    <button type="button" class="btn btn-secondary btn-sm w-100" onclick="openCMSPicker('navbarLogoInput', 'navbarLogoPreview')">
                        <i class="fas fa-image"></i> Select Logo
                    </button>
                </div>
                <div class="form-group">
                    <label>Navbar Button Text</label>
                    <input type="text" name="navbar_button_text" value="{{ $settings['navbar_button_text'] ?? '' }}" style="width: 100%;">
                </div>
            </div>
        </div>

        <div style="display: flex; justify-content: flex-end;">
            <button type="submit" class="btn btn-primary" style="padding: 0.75rem 2.5rem;">Save All Settings</button>
        </div>
    </form>
</div>
@endsection