@extends('layouts.admin')

@section('title', 'Edit Service')
@section('page_title', 'Update Service')

@section('content')
<div class="card" style="max-width: 1000px; margin: 0 auto;">
    <div class="card-header">
        <h2>Editing: {{ $service->title }}</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.services.update', $service) }}" method="POST">
            @csrf
            @method('PUT')

            <div style="display: grid; grid-template-columns: 1.5fr 1fr; gap: 30px;">
                <!-- Left Side -->
                <div>
                    <div class="form-group">
                        <label>Service Category <span style="color: red;">*</span></label>
                        <select name="category_id" class="form-control" required>
                            @foreach($categories as $cat)
                            <option value="{{ $cat->id }}" {{ $service->category_id == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Service Title <span style="color: red;">*</span></label>
                        <input type="text" name="title" class="form-control" value="{{ $service->title }}" required>
                    </div>

                    <div class="form-group">
                        <label>Slug</label>
                        <input type="text" name="slug" class="form-control" value="{{ $service->slug }}">
                    </div>

                    <div class="form-group">
                        <label>Short Description</label>
                        <textarea name="short_description" class="form-control" rows="3">{{ $service->short_description }}</textarea>
                    </div>
                </div>

                <!-- Right Side: Image -->
                <div>
                    <div class="form-group">
                        <label>Service Image</label>
                        <div style="margin-bottom: 20px; border: 2px dashed #eee; border-radius: 12px; padding: 10px; background: #fafafa; text-align: center;">
                            <img id="serviceImagePreview" src="{{ $service->imageFile ? asset($service->imageFile->path) : 'https://placehold.co/400x300' }}" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px;">
                        </div>
                        <input type="hidden" name="image" id="serviceImageInput" value="{{ $service->image }}">
                        <button type="button" class="btn btn-secondary w-100" onclick="openCMSPicker('serviceImageInput', 'serviceImagePreview')">
                            <i class="fas fa-image"></i> Change Image
                        </button>
                    </div>
                </div>
            </div>

            <!-- Full Description (CKEditor) -->
            <div class="form-group" style="margin-top: 20px;">
                <label>Full Content / Description</label>
                <textarea name="description" id="editor" class="form-control">{{ $service->description }}</textarea>
            </div>

            <!-- SEO Section -->
            <div style="margin-top: 2rem; padding-top: 1rem; border-top: 1px solid #edf2f7;">
                <h4 style="font-size: 0.85rem; text-transform: uppercase; color: #64748b; margin-bottom: 1rem;">SEO Meta Information</h4>
                <div class="form-group">
                    <label>Meta Title</label>
                    <input type="text" name="meta_title" class="form-control" value="{{ $service->meta_title }}">
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div class="form-group">
                        <label>Meta Keywords</label>
                        <textarea name="meta_keywords" class="form-control" rows="2">{{ $service->meta_keywords }}</textarea>
                    </div>
                    <div class="form-group">
                        <label>Meta Description</label>
                        <textarea name="meta_description" class="form-control" rows="2">{{ $service->meta_description }}</textarea>
                    </div>
                </div>
            </div>

            <div style="text-align: right; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <a href="{{ route('admin.services.index') }}" class="btn btn-secondary" style="margin-right: 10px;">Cancel</a>
                <button type="submit" class="btn btn-primary" style="padding: 0.7rem 2.5rem; font-weight: 700;">
                    UPDATE SERVICE
                </button>
            </div>
        </form>
    </div>
</div>

@section('scripts')
<script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });
</script>
@endsection

@endsection