{{-- Stored Products Treatment --}}
<div class="section-container">
    <h3 class="section-title"><i class="fas fa-boxes"></i> Main Section (Stored Products)</h3>
    <div class="grid-2">
        <div>
            <div class="form-group">
                <label>Tag</label>
                <input type="text" name="section1_tag" class="form-control" value="{{ $detail->section1_tag }}">
            </div>
            <div class="form-group">
                <label>Heading</label>
                <input type="text" name="section1_heading" class="form-control" value="{{ $detail->section1_heading }}">
            </div>
            <div class="form-group">
                <label>Description</label>
                <textarea name="section1_description" class="form-control" rows="4">{{ $detail->section1_description }}</textarea>
            </div>
        </div>
        <div>
            <label>Manage 3 Right-side Images</label>
            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px;">
                @for($i=1; $i<=3; $i++)
                    @php $imgField = "section1_image{$i}_id"; @endphp
                    <div class="image-preview-container" style="height: 120px;" onclick="openCMSPicker('img{{$i}}', 'prev{{$i}}')">
                        <input type="hidden" name="section1_image{{$i}}_id" id="img{{$i}}" value="{{ $detail->$imgField }}">
                        <div id="prev{{$i}}">
                            @if($detail->{"section1Image{$i}"})
                                <img src="{{ asset($detail->{"section1Image{$i}"}->path) }}">
                            @else
                                <div class="upload-placeholder">
                                    <i class="fas fa-image"></i>
                                    <p>Img {{$i}}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                @endfor
            </div>
        </div>
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-question-circle"></i> Why Invest Section</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="why_invest_heading" class="form-control" value="{{ $detail->why_invest_heading }}">
        </div>
        <div class="form-group">
            <label>Section Paragraph</label>
            <textarea name="why_invest_description" class="form-control" rows="2">{{ $detail->why_invest_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Why Invest Cards</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('why_invest', 'why-invest-container')">
            <i class="fas fa-plus"></i> Add Card
        </button>
    </div>

    <div id="why-invest-container">
        @foreach($detail->items->where('type', 'why_invest') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Icon Class</label>
                        <input type="text" name="items[why_invest][{{ $index }}][icon]" class="form-control" value="{{ $item->icon }}">
                    </div>
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="items[why_invest][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea name="items[why_invest][{{ $index }}][description]" class="form-control" rows="2">{{ $item->description }}</textarea>
                </div>
                <input type="hidden" name="items[why_invest][{{ $index }}][sort_order]" value="{{ $item->sort_order }}">
            </div>
        @endforeach
    </div>
</div>
