{{-- Residential Services --}}
<div class="section-container">
    <h3 class="section-title"><i class="fas fa-bug"></i> Common Pest Section</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Heading</label>
            <input type="text" name="common_pest_heading" class="form-control" value="{{ $detail->common_pest_heading }}">
        </div>
        <div class="form-group">
            <label>Paragraph</label>
            <textarea name="common_pest_description" class="form-control" rows="2">{{ $detail->common_pest_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Common Pest Cards</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('common_pest', 'common-pest-container')">
            <i class="fas fa-plus"></i> Add Pest Card
        </button>
    </div>

    <div id="common-pest-container">
        @foreach($detail->items->where('type', 'common_pest') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Image</label>
                        <div class="image-preview-container" style="height: 120px;" onclick="openCMSPicker('pest_img_{{$index}}', 'pest_prev_{{$index}}')">
                            <input type="hidden" name="items[common_pest][{{ $index }}][image_id]" id="pest_img_{{$index}}" value="{{ $item->image_id }}">
                            <div id="pest_prev_{{$index}}">
                                @if($item->image)
                                    <img src="{{ asset($item->image->path) }}">
                                @else
                                    <div class="upload-placeholder">
                                        <i class="fas fa-image"></i>
                                        <p>Select Image</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Heading</label>
                        <input type="text" name="items[common_pest][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                        <div class="form-group" style="margin-top:10px;">
                            <label>Paragraph</label>
                            <textarea name="items[common_pest][{{ $index }}][description]" class="form-control" rows="3">{{ $item->description }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-home"></i> How Residential Services Work</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="how_it_works_heading" class="form-control" value="{{ $detail->how_it_works_heading }}">
        </div>
        <div class="form-group">
            <label>Paragraph</label>
            <textarea name="how_it_works_description" class="form-control" rows="2">{{ $detail->how_it_works_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Process Flow (CRUD – 4 Steps)</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('process_flow', 'process-flow-container')">
            <i class="fas fa-plus"></i> Add Step
        </button>
    </div>

    <div id="process-flow-container">
        @foreach($detail->items->where('type', 'process_flow') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Icon</label>
                        <input type="text" name="items[process_flow][{{ $index }}][icon]" class="form-control" value="{{ $item->icon }}">
                    </div>
                    <div class="form-group">
                        <label>Heading</label>
                        <input type="text" name="items[process_flow][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="items[process_flow][{{ $index }}][description]" class="form-control" rows="2">{{ $item->description }}</textarea>
                </div>
            </div>
        @endforeach
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-shield-alt"></i> Why Invest Section</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="why_invest_heading" class="form-control" value="{{ $detail->why_invest_heading }}">
        </div>
        <div class="form-group">
            <label>Section Paragraph</label>
            <textarea name="why_invest_description" class="form-control" rows="2">{{ $detail->why_invest_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Why Invest Cards</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('why_invest', 'why-invest-container')">
            <i class="fas fa-plus"></i> Add Card
        </button>
    </div>

    <div id="why-invest-container">
        @foreach($detail->items->where('type', 'why_invest') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Icon</label>
                        <input type="text" name="items[why_invest][{{ $index }}][icon]" class="form-control" value="{{ $item->icon }}">
                    </div>
                    <div class="form-group">
                        <label>Heading</label>
                        <input type="text" name="items[why_invest][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="items[why_invest][{{ $index }}][description]" class="form-control" rows="2">{{ $item->description }}</textarea>
                </div>
            </div>
        @endforeach
    </div>
</div>
