{{-- Commercial Services --}}
<div class="section-container">
    <h3 class="section-title"><i class="fas fa-building"></i> Service Introduction</h3>
    <div class="form-group">
        <label>Heading</label>
        <input type="text" name="intro_heading" class="form-control" value="{{ $detail->intro_heading }}">
    </div>
    <div class="form-group">
        <label>Paragraph</label>
        <textarea name="intro_description" class="form-control" rows="3">{{ $detail->intro_description }}</textarea>
    </div>
</div>

<div class="grid-2">
    <div class="section-container">
        <h3 class="section-title"><i class="fas fa-exclamation-triangle"></i> Risk Block</h3>
        <div class="form-group">
            <label>Tag</label>
            <input type="text" name="risk_tag" class="form-control" value="{{ $detail->risk_tag }}">
        </div>
        <div class="form-group">
            <label>Heading</label>
            <input type="text" name="risk_heading" class="form-control" value="{{ $detail->risk_heading }}">
        </div>
        <div class="form-group">
            <label>Short Paragraph</label>
            <textarea name="risk_subtitle" class="form-control" rows="2">{{ $detail->risk_subtitle }}</textarea>
        </div>
        <div class="form-group">
            <label>Description (Rich Text)</label>
            <textarea name="risk_description" class="form-control rich-editor">{{ $detail->risk_description }}</textarea>
        </div>
    </div>
    <div class="section-container">
        <h3 class="section-title"><i class="fas fa-thumbs-up"></i> Benefit Block</h3>
        <div class="form-group">
            <label>Tag</label>
            <input type="text" name="benefit_tag" class="form-control" value="{{ $detail->benefit_tag }}">
        </div>
        <div class="form-group">
            <label>Heading</label>
            <input type="text" name="benefit_heading" class="form-control" value="{{ $detail->benefit_heading }}">
        </div>
        <div class="form-group">
            <label>Short Paragraph</label>
            <textarea name="benefit_subtitle" class="form-control" rows="2">{{ $detail->benefit_subtitle }}</textarea>
        </div>
        <div class="form-group">
            <label>Description (Rich Text)</label>
            <textarea name="benefit_description" class="form-control rich-editor">{{ $detail->benefit_description }}</textarea>
        </div>
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-tools"></i> How Commercial Services Work</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="how_it_works_heading" class="form-control" value="{{ $detail->how_it_works_heading }}">
        </div>
        <div class="form-group">
            <label>Paragraph</label>
            <textarea name="how_it_works_description" class="form-control" rows="2">{{ $detail->how_it_works_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Process Flow (CRUD – 4 Steps)</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('process_flow', 'process-flow-container')">
            <i class="fas fa-plus"></i> Add Step
        </button>
    </div>

    <div id="process-flow-container">
        @foreach($detail->items->where('type', 'process_flow') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Icon</label>
                        <input type="text" name="items[process_flow][{{ $index }}][icon]" class="form-control" value="{{ $item->icon }}">
                    </div>
                    <div class="form-group">
                        <label>Heading</label>
                        <input type="text" name="items[process_flow][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="items[process_flow][{{ $index }}][description]" class="form-control" rows="2">{{ $item->description }}</textarea>
                </div>
            </div>
        @endforeach
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-file-contract"></i> Tracking and Reporting</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="tracking_heading" class="form-control" value="{{ $detail->tracking_heading }}">
        </div>
        <div class="form-group">
            <label>Paragraph</label>
            <textarea name="tracking_description" class="form-control" rows="2">{{ $detail->tracking_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Tracking Steps (CRUD – 4 Items)</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('tracking_step', 'tracking-container')">
            <i class="fas fa-plus"></i> Add Tracking Step
        </button>
    </div>

    <div id="tracking-container">
        @foreach($detail->items->where('type', 'tracking_step') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="form-group">
                    <label>Heading</label>
                    <input type="text" name="items[tracking_step][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    <div class="form-group" style="margin-top:10px;">
                        <label>Paragraph</label>
                        <textarea name="items[tracking_step][{{ $index }}][description]" class="form-control" rows="3">{{ $item->description }}</textarea>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-user-shield"></i> Why Invest Section</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="why_invest_heading" class="form-control" value="{{ $detail->why_invest_heading }}">
        </div>
        <div class="form-group">
            <label>Section Paragraph</label>
            <textarea name="why_invest_description" class="form-control" rows="2">{{ $detail->why_invest_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Why Invest Cards</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('why_invest', 'why-invest-container')">
            <i class="fas fa-plus"></i> Add Card
        </button>
    </div>

    <div id="why-invest-container">
        @foreach($detail->items->where('type', 'why_invest') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Icon</label>
                        <input type="text" name="items[why_invest][{{ $index }}][icon]" class="form-control" value="{{ $item->icon }}">
                    </div>
                    <div class="form-group">
                        <label>Heading</label>
                        <input type="text" name="items[why_invest][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="items[why_invest][{{ $index }}][description]" class="form-control" rows="2">{{ $item->description }}</textarea>
                </div>
            </div>
        @endforeach
    </div>
</div>
