@extends('layouts.admin')

@section('title', 'Add Service Category')
@section('page_title', 'Create Service Category')

@section('content')
<div class="card" style="max-width: 800px; margin: 0 auto;">
    <div class="card-header">
        <h2>Category Details</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.service-categories.store') }}" method="POST">
            @csrf
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                <div class="form-group">
                    <label>Category Name <span style="color: red;">*</span></label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Slug (Optional)</label>
                    <input type="text" name="slug" class="form-control" placeholder="auto-generated if empty">
                </div>
                <div class="form-group">
                    <label>Icon Class (FontAwesome)</label>
                    <input type="text" name="icon" class="form-control" placeholder="e.g. fas fa-heartbeat">
                </div>
                <div class="form-group" style="display: flex; align-items: center; gap: 10px; padding-top: 1.5rem;">
                    <input type="checkbox" name="is_top" id="isTop" value="1" style="width: 20px; height: 20px;">
                    <label for="isTop" style="margin-bottom: 0;">Show in Top Services</label>
                </div>
                <div class="form-group">
                    <label>Category Image</label>
                    <div style="width: 100%; height: 150px; background: #f8fafc; border: 2px dashed #cbd5e1; border-radius: 8px; display: flex; align-items: center; justify-content: center; cursor: pointer; position: relative; overflow: hidden;" onclick="openCMSPicker('image_id', 'image_preview')">
                        <input type="hidden" name="image_id" id="image_id">
                        <div id="image_preview">
                            <div style="text-align: center; color: #64748b;">
                                <i class="fas fa-cloud-upload-alt fa-2x"></i>
                                <p>Click to Select Image</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group" style="grid-column: span 2;">
                    <label>Description</label>
                    <textarea name="description" class="form-control" rows="3"></textarea>
                </div>

                <!-- SEO Section -->
                <div style="grid-column: span 2; margin-top: 1rem; padding-top: 1rem; border-top: 1px solid #edf2f7;">
                    <h4 style="font-size: 0.85rem; text-transform: uppercase; color: #64748b; margin-bottom: 1rem;">SEO Meta Information</h4>
                </div>
                
                <div class="form-group" style="grid-column: span 2;">
                    <label>Meta Title</label>
                    <input type="text" name="meta_title" class="form-control">
                </div>
                <div class="form-group">
                    <label>Meta Keywords</label>
                    <textarea name="meta_keywords" class="form-control" rows="2"></textarea>
                </div>
                <div class="form-group">
                    <label>Meta Description</label>
                    <textarea name="meta_description" class="form-control" rows="2"></textarea>
                </div>
            </div>

            <div style="text-align: right; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <a href="{{ route('admin.service-categories.index') }}" class="btn btn-secondary" style="margin-right: 10px;">Cancel</a>
                <button type="submit" class="btn btn-primary" style="padding: 0.7rem 2.5rem; font-weight: 700;">
                    SAVE CATEGORY
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
