@extends('layouts.admin')

@section('title', 'Service Areas')
@section('page_title', 'Manage Service Areas')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Service Areas List</h2>
        <a href="{{ route('admin.service-areas.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Area
        </a>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Short Description</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($areas as $area)
                <tr>
                    <td style="width: 60px; text-align: center;">
                        <i class="{{ $area->icon ?: 'fas fa-map-marker-alt' }} fa-lg" style="color: var(--primary-red);"></i>
                    </td>
                    <td style="font-weight: 700;">{{ $area->name }}</td>
                    <td><code>{{ $area->slug }}</code></td>
                    <td style="font-size: 0.85rem; color: #64748b;">{{ Str::limit($area->short_description, 50) }}</td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.service-areas.edit', $area) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.service-areas.destroy', $area) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="text-align: center; padding: 3rem; color: #94a3b8;">
                        No service areas found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
