@extends('layouts.admin')

@section('title', 'Edit Registration')
@section('page_title', 'Update Registration')

@section('content')
<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="card-header">
        <h2>Edit Registration</h2>
    </div>
    <form action="{{ route('admin.registrations.update', $registration) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="form-group">
            <label>Name</label>
            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $registration->name) }}" required>
            @error('name') <div style="color: var(--primary-red); font-size: 0.8rem; margin-top: 5px;">{{ $message }}</div> @enderror
        </div>

        <div class="form-group">
            <label>Registration Image/Logo</label>
            <div style="margin-bottom: 10px;">
                <div style="margin-bottom: 10px;">
                    <img id="imagePreview" src="{{ $registration->imageFile ? asset($registration->imageFile->path) : 'https://placehold.co/150x150' }}" style="width: 150px; height: 150px; border-radius: 12px; border: 1px solid #ddd; object-fit: cover;">
                </div>
                <input type="hidden" name="image" id="imageInput" value="{{ old('image', $registration->image) }}">
                <button type="button" class="btn btn-secondary" onclick="openCMSPicker('imageInput', 'imagePreview')" style="width: 100%;">
                    <i class="fas fa-image"></i> Change Image
                </button>
            </div>

            <div style="margin-top: 2rem; display: flex; gap: 10px; justify-content: flex-end;">
                <a href="{{ route('admin.registrations.index') }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Registration
                </button>
            </div>
    </form>
</div>
@endsection