@extends('layouts.admin')

@section('title', 'Why Choose Us CMS')
@section('page_title', 'Why Choose Us Section')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Section Settings</h2>
        <a href="{{ route('admin.why-choose-us.index') }}" class="btn btn-secondary">
            <i class="fas fa-list"></i> Manage Feature Cards
        </a>
    </div>
    <form action="{{ route('admin.pages.why-choose-us.update') }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Section Heading</label>
                    <input type="text" name="section[heading]" value="{{ $section->heading }}" class="form-control">
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="section[paragraph]" class="form-control" rows="5">{{ $section->paragraph }}</textarea>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Button Text</label>
                            <input type="text" name="section[btn_text]" value="{{ $section->btn_text }}" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Button URL</label>
                            <input type="text" name="section[btn_url]" value="{{ $section->btn_url }}" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Center Image</label>
                    <div style="margin-bottom: 10px;">
                        <img id="centerImagePreview" src="{{ $section->image ? asset($section->image) : 'https://placehold.co/400x400' }}" style="width: 100%; max-height: 300px; border-radius: 12px; border: 1px solid #ddd; object-fit: contain; background: #f8fafc;">
                    </div>
                    <input type="hidden" name="section[image]" id="centerImageInput" value="{{ $section->image }}">
                    <button type="button" class="btn btn-secondary w-100" onclick="openCMSPicker('centerImageInput', 'centerImagePreview')">
                        <i class="fas fa-image"></i> Select Image
                    </button>
                </div>
            </div>
        </div>

        <div style="margin-top: 2rem; text-align: right;">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save"></i> Save Section Details
            </button>
        </div>
    </form>
</div>
@endsection

@section('styles')
<style>
    .row { display: flex; flex-wrap: wrap; margin-right: -15px; margin-left: -15px; }
    .col-md-6 { flex: 0 0 50%; max-width: 50%; padding: 0 15px; }
    .form-control { width: 100%; padding: 0.8rem 1rem; border: 2px solid #edf2f7; border-radius: 10px; font-size: 1rem; }
    .w-100 { width: 100%; }
</style>
@endsection
