@extends('layouts.admin')

@section('title', 'Page SEO')
@section('page_title', 'Manage Page SEO')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>General Page SEO Settings</h2>
        <a href="{{ route('admin.page-seos.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Page SEO
        </a>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Page Name</th>
                    <th>Meta Title</th>
                    <th>Last Updated</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($seos as $seo)
                <tr>
                    <td style="font-weight: 700;">{{ $seo->page_name }}</td>
                    <td style="font-size: 0.85rem; color: #64748b;">{{ Str::limit($seo->meta_title, 50) }}</td>
                    <td>{{ $seo->updated_at->format('M d, Y') }}</td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.page-seos.edit', $seo) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.page-seos.destroy', $seo) }}" method="POST" onsubmit="return confirm('Delete this page SEO setting?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" style="text-align: center; padding: 3rem; color: #94a3b8;">
                        No page SEO settings found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
