@extends('layouts.admin')

@section('title', 'Edit Page SEO')
@section('page_title', 'Update Page SEO')

@section('content')
<div class="card" style="max-width: 800px; margin: 0 auto;">
    <div class="card-header">
        <h2>Editing SEO for: {{ $page_seo->page_name }}</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.page-seos.update', $page_seo) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="form-group">
                <label>Page Name <span style="color: red;">*</span></label>
                <input type="text" name="page_name" class="form-control" value="{{ $page_seo->page_name }}" readonly>
                <p style="font-size: 0.75rem; color: #94a3b8; margin-top: 5px;">Page name cannot be changed.</p>
            </div>

            <div class="form-group">
                <label>Meta Title</label>
                <input type="text" name="meta_title" class="form-control" value="{{ $page_seo->meta_title }}">
            </div>

            <div class="form-group">
                <label>Meta Keywords</label>
                <textarea name="meta_keywords" class="form-control" rows="3">{{ $page_seo->meta_keywords }}</textarea>
            </div>

            <div class="form-group">
                <label>Meta Description</label>
                <textarea name="meta_description" class="form-control" rows="4">{{ $page_seo->meta_description }}</textarea>
            </div>

            <div style="text-align: right; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <a href="{{ route('admin.page-seos.index') }}" class="btn btn-secondary" style="margin-right: 10px;">Cancel</a>
                <button type="submit" class="btn btn-primary" style="padding: 0.7rem 2.5rem; font-weight: 700;">
                    UPDATE SEO SETTINGS
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
