@extends('layouts.admin')

@section('title', 'Add Page SEO')
@section('page_title', 'Create Page SEO')

@section('content')
<div class="card" style="max-width: 800px; margin: 0 auto;">
    <div class="card-header">
        <h2>SEO Details</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.page-seos.store') }}" method="POST">
            @csrf
            
            <div class="form-group">
                <label>Page Name / Selection <span style="color: red;">*</span></label>
                <select name="page_name" class="form-control" required>
                    <option value="">Select Page</option>
                    <option value="Home">Home</option>
                    <option value="About Us">About Us</option>
                    <option value="Services">Services</option>
                    <option value="Products">Products</option>
                    <option value="Blogs">Blogs</option>
                    <option value="Contact Us">Contact Us</option>
                    <option value="Cart">Cart</option>
                    <option value="Checkout">Checkout</option>
                </select>
            </div>

            <div class="form-group">
                <label>Meta Title</label>
                <input type="text" name="meta_title" class="form-control" placeholder="The title tag for SEO">
            </div>

            <div class="form-group">
                <label>Meta Keywords</label>
                <textarea name="meta_keywords" class="form-control" rows="3" placeholder="Comma separated keywords..."></textarea>
            </div>

            <div class="form-group">
                <label>Meta Description</label>
                <textarea name="meta_description" class="form-control" rows="4" placeholder="Brief summary of the page..."></textarea>
            </div>

            <div style="text-align: right; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <a href="{{ route('admin.page-seos.index') }}" class="btn btn-secondary" style="margin-right: 10px;">Cancel</a>
                <button type="submit" class="btn btn-primary" style="padding: 0.7rem 2.5rem; font-weight: 700;">
                    SAVE SEO SETTINGS
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
