@extends('layouts.admin')

@section('title', 'Edit Navbar Link')

@section('content')
<div style="max-width: 800px; margin: 0 auto;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h2 style="font-size: 1.5rem; color: #1a202c;">Edit Navbar Link</h2>
        <a href="{{ route('admin.navbar-links.index') }}" class="btn btn-secondary">Back to List</a>
    </div>

    <div class="card" style="padding: 2rem;">
        <form action="{{ route('admin.navbar-links.update', $navbarLink->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>Title</label>
                <input type="text" name="title" class="form-control" value="{{ $navbarLink->title }}" required>
            </div>

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>URL</label>
                <input type="text" name="url" class="form-control" value="{{ $navbarLink->url }}" placeholder="/services or https://example.com">
            </div>

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>Order</label>
                <input type="number" name="order" class="form-control" value="{{ $navbarLink->order }}">
            </div>

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>Status</label>
                <select name="status" class="form-control">
                    <option value="1" {{ $navbarLink->status ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ !$navbarLink->status ? 'selected' : '' }}>Inactive</option>
                </select>
            </div>

            <div style="display: flex; justify-content: flex-end; gap: 1rem; margin-top: 2rem;">
                <button type="submit" class="btn btn-primary">Update Link</button>
            </div>
        </form>
    </div>
</div>
@endsection
