@extends('layouts.admin')

@section('title', 'Folder: ' . $folder->name)

@section('styles')
<style>
    .image-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 1.5rem;
    }

    .image-item {
        min-width: 0;
        overflow: hidden;
    }

    .image-item {
        background: #ffffff;
        border-radius: 12px;
        padding: 1rem;
        text-align: center;
        transition: all 0.3s ease;
        position: relative;
        border: 1px solid #edf2f7;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.02);
    }

    .image-item:hover {
        transform: translateY(-4px);
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.08);
        border-color: #cbd5e0;
    }

    .image-thumb {
        width: 100%;
        height: 140px;
        object-fit: cover;
        border-radius: 8px;
        margin-bottom: 0.8rem;
        background: #f1f5f9;
    }

    .image-name {
        font-weight: 600;
        font-size: 0.95rem;
        color: #2d3748;
        display: block;
        word-break: break-all;
        margin-bottom: 0.5rem;
    }

    .item-actions {
        display: flex;
        justify-content: center;
        gap: 8px;
        opacity: 0;
        transition: opacity 0.2s;
        position: absolute;
        top: 8px;
        right: 8px;
        background: rgba(255, 255, 255, 0.95);
        padding: 4px;
        border-radius: 6px;
        backdrop-filter: blur(4px);
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        z-index: 10;
    }

    .image-item:hover .item-actions {
        opacity: 1;
    }
</style>
@endsection

@section('content')
<div style="margin-bottom: 1rem;">
    <a href="{{ route('admin.images.index') }}" style="color: var(--primary-red); text-decoration: none; font-weight: 600;">
        <i class="fas fa-arrow-left"></i> Back to Root
    </a>
</div>

@if(session('success'))
<div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
    {{ session('success') }}
</div>
@endif

@if($errors->any())
<div style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
    <ul style="margin: 0;">
        @foreach($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Images in "{{ $folder->name }}"</h2>
        <button class="btn btn-primary" onclick="openModal('uploadModal')">
            <i class="fas fa-cloud-upload-alt"></i> Upload Images
        </button>
    </div>
    <div class="image-grid">
        @forelse($images as $image)
        <div class="image-item">
            <div class="item-actions">
                <button class="action-btn btn-move" title="Move Image" onclick="openMoveModal('{{ $image->id }}', '{{ $image->folder_id }}')">
                    <i class="fas fa-file-export"></i>
                </button>
                <form action="{{ route('admin.images.delete', $image->id) }}" method="POST" onsubmit="return confirm('Delete this image?')" style="display:inline;">
                    @csrf @method('DELETE')
                    <button type="submit" class="action-btn btn-delete" title="Delete Image">
                        <i class="fas fa-trash"></i>
                    </button>
                </form>
            </div>
            <img src="{{ asset($image->path) }}" class="image-thumb" alt="{{ $image->original_name }}">
            <span class="image-name" title="{{ $image->original_name }}">{{ Str::limit($image->original_name, 15) }}</span>
        </div>
        @empty
        <p style="color: #666;">No images in this folder.</p>
        @endforelse
    </div>
    <div class="pagination">
        {{ $images->links() }}
    </div>
</div>

<!-- Upload Modal -->
<div id="uploadModal" class="modal">
    <div class="modal-content" style="max-width: 600px;">
        <div class="modal-header">
            <h3>Upload Images to {{ $folder->name }}</h3>
            <button type="button" class="action-btn btn-secondary" onclick="closeModal('uploadModal')" style="background:none; color:#64748b;">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form action="{{ route('admin.images.upload') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="folder_id" value="{{ $folder->id }}">
            <div class="modal-body" style="padding: 2rem;">
                <div class="form-group">
                    <label class="form-label">Custom Prefix Name (Optional)</label>
                    <input type="text" name="custom_name" id="custom_name" class="form-control" placeholder="Leaving empty uses original filename">
                    <small style="color: #64748b;">Images will be renamed with this prefix (e.g. intro_1.jpg)</small>
                </div>
                <div class="form-group">
                    <label class="form-label">Select Files</label>
                    <div style="border: 2px dashed #e2e8f0; padding: 2rem; border-radius: 12px; text-align: center; background: #f8fafc;">
                        <input type="file" name="images[]" id="images" multiple required accept="image/*" style="opacity: 0; position: absolute; width: 0.1px; height: 0.1px;">
                        <label for="images" style="cursor: pointer;">
                            <i class="fas fa-cloud-upload-alt fa-3x" style="color: var(--primary-red); margin-bottom: 1rem;"></i>
                            <p style="font-weight: 600; color: #1e293b;">Click to select or drag and drop</p>
                            <p style="font-size: 0.8rem; color: #64748b;">PNG, JPG, SVG up to 5MB</p>
                        </label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('uploadModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Start Upload</button>
            </div>
        </form>
    </div>
</div>

<!-- Move Modal -->
<div id="moveModal" class="modal">
    <div class="modal-content" style="max-width: 500px;">
        <div class="modal-header">
            <h3>Move Image</h3>
            <button type="button" class="action-btn btn-secondary" onclick="closeModal('moveModal')" style="background:none; color:#64748b;">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form id="moveForm" action="" method="POST">
            @csrf @method('PUT')
            <div class="modal-body" style="padding: 2rem;">
                <div class="form-group">
                    <label class="form-label">Destination Folder</label>
                    <select name="folder_id" id="target_folder" class="form-control">
                        <option value="">Root Directory</option>
                        @foreach($folders as $f)
                        <option value="{{ $f->id }}" {{ $f->id == $folder->id ? 'selected' : '' }}>{{ $f->name }}</option>
                        @endforeach
                    </select>
                </div>
                <p style="color: #64748b; font-size: 0.85rem;">
                    <i class="fas fa-info-circle"></i> Moving an image will update its internal file structure.
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('moveModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Move Now</button>
            </div>
        </form>
    </div>
</div>

@endsection

@section('scripts')
<script>
    function openModal(id) {
        const modal = document.getElementById(id);
        modal.style.display = 'flex';
        setTimeout(() => modal.classList.add('show'), 10);
    }

    function closeModal(id) {
        const modal = document.getElementById(id);
        modal.classList.remove('show');
        setTimeout(() => modal.style.display = 'none', 300);
    }

    function openMoveModal(imageId, currentFolderId) {
        const form = document.getElementById('moveForm');
        form.action = "{{ url('admin/images') }}/" + imageId + "/move";
        document.getElementById('target_folder').value = currentFolderId || "";
        openModal('moveModal');
    }
</script>
@endsection