@extends('layouts.admin')

@section('title', 'FAQs')
@section('page_title', 'Manage FAQs')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Frequently Asked Questions</h2>
        <a href="{{ route('admin.faqs.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New FAQ
        </a>
    </div>

    <div style="padding: 1rem 2rem;">
        @forelse($faqs as $faq)
        <div style="background: #f8fafc; border: 1px solid #eef2f7; border-radius: 12px; padding: 1.5rem; margin-bottom: 20px; position: relative;">
            <div style="position: absolute; top: 1.5rem; right: 1.5rem; display: flex; gap: 8px;">
                <a href="{{ route('admin.faqs.edit', $faq) }}" class="action-btn btn-edit">
                    <i class="fas fa-edit"></i>
                </a>
                <form action="{{ route('admin.faqs.destroy', $faq) }}" method="POST" onsubmit="return confirm('Delete this FAQ?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="action-btn btn-delete">
                        <i class="fas fa-trash"></i>
                    </button>
                </form>
            </div>
            
            <h3 style="margin: 0 0 10px; color: #1e293b; font-size: 1.1rem; padding-right: 80px;">Q: {{ $faq->question }}</h3>
            <p style="margin: 0; color: #64748b; line-height: 1.6;">A: {{ $faq->answer }}</p>
        </div>
        @empty
        <div style="text-align: center; padding: 3rem; color: #94a3b8;">
            No FAQs found.
        </div>
        @endforelse
    </div>
</div>
@endsection
