@extends('layouts.admin')

@section('title', 'Add FAQ')
@section('page_title', 'Create New FAQ')

@section('content')
<div class="card" style="max-width: 700px; margin: 0 auto;">
    <div class="card-header">
        <h2>FAQ Details</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.faqs.store') }}" method="POST">
            @csrf
            <div class="form-group">
                <label>Question <span style="color: red;">*</span></label>
                <textarea name="question" class="form-control" rows="3" required placeholder="What is the question?"></textarea>
            </div>
            <div class="form-group">
                <label>Answer <span style="color: red;">*</span></label>
                <textarea name="answer" class="form-control" rows="6" required placeholder="Provide a detailed answer..."></textarea>
            </div>

            <div style="text-align: right; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <a href="{{ route('admin.faqs.index') }}" class="btn btn-secondary" style="margin-right: 10px;">Cancel</a>
                <button type="submit" class="btn btn-primary" style="padding: 0.7rem 2.5rem; font-weight: 700;">
                    SAVE FAQ
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
