@extends('layouts.admin')

@section('title', 'Contact Messages')
@section('page_title', 'User Messages')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>All Contact Messages</h2>
    </div>
    
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Service</th>
                    <th>Message</th>
                </tr>
            </thead>
            <tbody>
                @forelse($messages as $msg)
                <tr>
                    <td style="white-space: nowrap;">{{ $msg->created_at->format('M d, Y H:i') }}</td>
                    <td style="font-weight: 600;">{{ $msg->name }}</td>
                    <td>{{ $msg->email }}</td>
                    <td>{{ $msg->phone }}</td>
                    <td><span class="badge badge-info">{{ $msg->service }}</span></td>
                    <td>
                        <p style="max-width: 300px; font-size: 0.85rem; color: #64748b; margin: 0;">{{ $msg->message }}</p>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-inbox" style="font-size: 3rem; color: #e2e8f0; margin-bottom: 1rem; display: block;"></i>
                        No messages found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div style="margin-top: 1.5rem;">
        {{ $messages->links() }}
    </div>
</div>
@endsection
