@extends('layouts.admin')

@section('title', 'Manage Blogs')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Blogs</h2>
        <a href="{{ route('admin.blogs.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add Blog
        </a>
    </div>

    @if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        {{ session('success') }}
    </div>
    @endif

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Title</th>
                    <th>Author</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($blogs as $blog)
                <tr>
                    <td>
                        @if($blog->image)
                        <img src="/{{ $blog->image->path }}" style="width: 60px; height: 40px; object-fit: cover; border-radius: 6px;">
                        @else
                        <div style="width: 60px; height: 40px; background: #f1f1f1; border-radius: 6px; display: flex; align-items:center; justify-content:center;">
                            <i class="fas fa-image" style="color:#ccc;"></i>
                        </div>
                        @endif
                    </td>
                    <td style="font-weight: 600;">{{ $blog->title }}</td>
                    <td>{{ $blog->author_name }}</td>
                    <td>
                        <span class="badge {{ $blog->status == 'active' ? 'badge-success' : 'badge-danger' }}">
                            {{ ucfirst($blog->status) }}
                        </span>
                    </td>
                    <td>
                        <a href="{{ route('admin.blogs.edit', $blog->id) }}" class="action-btn btn-edit">
                            <i class="fas fa-edit"></i>
                        </a>
                        <form action="{{ route('admin.blogs.destroy', $blog->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete blog?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="action-btn btn-delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="padding: 2rem; text-align: center; color: #666;">No blogs found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="pagination">
        {{ $blogs->links() }}
    </div>
</div>
@endsection