@extends('layouts.admin')

@section('title', 'Add Blog')

@section('content')
<form action="{{ route('admin.blogs.store') }}" method="POST">
    @csrf
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h2 style="font-size: 1.5rem; color: #1a202c;">Add New Blog</h2>
        <div style="display: flex; gap: 10px;">
            <a href="{{ route('admin.blogs.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Save Blog</button>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: 2.2fr 1fr; gap: 2rem;">
        <!-- Left Side: Content -->
        <div class="card" style="padding: 2rem;">
            <div class="form-group">
                <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Blog Title</label>
                <input type="text" name="title" id="blog_title" value="{{ old('title') }}" required style="width: 100%;" placeholder="Enter post title">
            </div>

            <div class="form-group">
                <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Slug (Optional)</label>
                <input type="text" name="slug" id="blog_slug" value="{{ old('slug') }}" style="width: 100%;" placeholder="url-slug">
            </div>

            <div class="form-group">
                <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Short Description</label>
                <textarea name="short_description" id="short_editor">{{ old('short_description') }}</textarea>
            </div>

            <div class="form-group">
                <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Full Description</label>
                <textarea name="description" id="description_editor">{{ old('description') }}</textarea>
            </div>
        </div>

        <!-- Right Side: Meta -->
        <div style="display: flex; flex-direction: column; gap: 2rem;">
            <div class="card" style="padding: 1.5rem;">
                <h3 style="font-size: 1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">Main Image</h3>
                <div class="form-group">
                    <div id="blog_image_preview" style="width: 100%; height: 200px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; align-items:center; justify-content:center; overflow:hidden; cursor: pointer;" onclick="openPicker('single', 'blog_image_id', 'blog_image_preview')">
                        <i class="fas fa-cloud-upload-alt" style="font-size: 2.5rem; color: #cbd5e0;"></i>
                    </div>
                    <input type="hidden" name="image_id" id="blog_image_id">
                    <button type="button" class="btn btn-secondary btn-sm" style="width: 100%; margin-top: 1rem;" onclick="openPicker('single', 'blog_image_id', 'blog_image_preview')">
                        Select Main Image
                    </button>
                </div>
            </div>

            <div class="card" style="padding: 1.5rem;">
                <h3 style="font-size: 1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">Author Details</h3>
                <div class="form-group">
                    <label style="font-weight: 600; font-size: 0.85rem;">Author Name</label>
                    <input type="text" name="author_name" value="{{ old('author_name', 'Admin') }}" style="width: 100%;">
                </div>
                <div class="form-group" style="margin-top: 1rem;">
                    <label style="font-weight: 600; font-size: 0.85rem;">Author Photo</label>
                    <div style="display: flex; gap: 10px; align-items: center;">
                        <div id="author_image_preview" style="width: 60px; height: 60px; background: #f8fafc; border-radius: 50%; border: 2px dashed #edf2f7; display: flex; align-items:center; justify-content:center; overflow:hidden; cursor: pointer;" onclick="openPicker('single', 'author_image_id', 'author_image_preview')">
                            <i class="fas fa-user" style="color: #cbd5e0;"></i>
                        </div>
                        <input type="hidden" name="author_image_id" id="author_image_id">
                        <button type="button" class="btn btn-secondary btn-sm" onclick="openPicker('single', 'author_image_id', 'author_image_preview')">Browse</button>
                    </div>
                </div>
            </div>

            <div class="card" style="padding: 1.5rem;">
                <h3 style="font-size: 1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">Status</h3>
                <div class="form-group">
                    <select name="status" style="width: 100%;">
                        <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
            </div>
        </div>
    </div>
</form>

@endsection

@section('scripts')
<script src="https://cdn.ckeditor.com/ckeditor5/35.1.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor.create(document.querySelector('#short_editor')).catch(error => {
        console.error(error);
    });
    ClassicEditor.create(document.querySelector('#description_editor')).catch(error => {
        console.error(error);
    });

    // Auto-slug
    document.getElementById('blog_title').addEventListener('input', function() {
        let title = this.value;
        let slug = title.toLowerCase().replace(/[^a-z0-9]+/g, '-').replace(/^-+|-+$/g, '');
        document.getElementById('blog_slug').value = slug;
    });
</script>
@endsection