<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_category_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_category_detail_id')->constrained()->onDelete('cascade');
            $table->string('type'); // e.g. 'why_invest', 'process_flow', 'common_pest', 'tracking_step'
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->string('icon')->nullable();
            $table->foreignId('image_id')->nullable()->constrained('images')->onDelete('set null');
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_category_items');
    }
};
