<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_category_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_category_id')->constrained()->onDelete('cascade');
            
            // Global: Hero Section
            $table->string('hero_heading')->nullable();
            $table->text('hero_description')->nullable();
            $table->foreignId('hero_image_id')->nullable()->constrained('images')->onDelete('set null');
            $table->string('hero_cta1_text')->nullable();
            $table->string('hero_cta1_url')->nullable();
            $table->string('hero_cta2_text')->nullable();
            $table->string('hero_cta2_url')->nullable();

            // Global: Banner Section
            $table->string('banner_heading')->nullable();
            $table->text('banner_description')->nullable();
            $table->string('banner_b1_text')->nullable();
            $table->string('banner_b1_url')->nullable();
            $table->string('banner_b2_text')->nullable();
            $table->string('banner_b2_url')->nullable();

            // Sections
            $table->string('section1_tag')->nullable();
            $table->string('section1_heading')->nullable();
            $table->text('section1_description')->nullable();
            $table->foreignId('section1_image1_id')->nullable()->constrained('images')->onDelete('set null');
            $table->foreignId('section1_image2_id')->nullable()->constrained('images')->onDelete('set null');
            $table->foreignId('section1_image3_id')->nullable()->constrained('images')->onDelete('set null');

            $table->string('section2_tag')->nullable();
            $table->string('section2_heading')->nullable();
            $table->text('section2_description')->nullable();
            $table->foreignId('section2_image_id')->nullable()->constrained('images')->onDelete('set null');

            $table->string('why_invest_heading')->nullable();
            $table->text('why_invest_description')->nullable();

            $table->string('how_it_works_heading')->nullable();
            $table->text('how_it_works_description')->nullable();

            $table->string('common_pest_heading')->nullable();
            $table->text('common_pest_description')->nullable();

            // Commercial Specific
            $table->string('intro_heading')->nullable();
            $table->text('intro_description')->nullable();

            $table->string('risk_tag')->nullable();
            $table->string('risk_heading')->nullable();
            $table->text('risk_subtitle')->nullable();
            $table->longText('risk_description')->nullable(); // Rich text

            $table->string('benefit_tag')->nullable();
            $table->string('benefit_heading')->nullable();
            $table->text('benefit_subtitle')->nullable();
            $table->longText('benefit_description')->nullable(); // Rich text

            $table->string('tracking_heading')->nullable();
            $table->text('tracking_description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_category_details');
    }
};
