<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        if (!function_exists('asset_encoded')) {
            /** Build asset URL with path segments encoded (spaces → %20) so product images with spaces in filenames load. */
            function asset_encoded(?string $path): string
            {
                if ($path === null || $path === '') {
                    return '';
                }
                $path = ltrim(str_replace('\\', '/', $path), '/');
                return asset(implode('/', array_map('rawurlencode', explode('/', $path))));
            }
        }
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Paginator::useBootstrapFour();
        if (\Illuminate\Support\Facades\Schema::hasTable('settings')) {
            $settings = \App\Models\Setting::all()->pluck('value', 'key');

            if ($settings->isNotEmpty()) {
                // Mail Overrides
                if (isset($settings['MAIL_HOST'])) config(['mail.mailers.smtp.host' => $settings['MAIL_HOST']]);
                if (isset($settings['MAIL_PORT'])) config(['mail.mailers.smtp.port' => $settings['MAIL_PORT']]);
                if (isset($settings['MAIL_USERNAME'])) config(['mail.mailers.smtp.username' => $settings['MAIL_USERNAME']]);
                if (isset($settings['MAIL_PASSWORD'])) config(['mail.mailers.smtp.password' => $settings['MAIL_PASSWORD']]);
                if (isset($settings['MAIL_ENCRYPTION'])) config(['mail.mailers.smtp.encryption' => $settings['MAIL_ENCRYPTION']]);
                if (isset($settings['MAIL_FROM_ADDRESS'])) {
                    config(['mail.from.address' => $settings['MAIL_FROM_ADDRESS']]);
                    config(['mail.from.name' => get_setting('MAIL_FROM_NAME', config('app.name'))]);
                }

                // Stripe Overrides
                if (isset($settings['STRIPE_KEY'])) config(['services.stripe.key' => $settings['STRIPE_KEY']]);
                if (isset($settings['STRIPE_SECRET'])) config(['services.stripe.secret' => $settings['STRIPE_SECRET']]);
            }
        }
    }
}
