<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Testimonial extends Model
{
    protected $fillable = [
        'client_image',
        'client_name',
        'designation',
        'message',
        'rating',
    ];

    public function imageFile()
    {
        return $this->belongsTo(Image::class, 'client_image');
    }

    public function toArray()
    {
        $attributes = parent::toArray();
        $raw = $attributes['client_image'] ?? null;
        if ($this->imageFile) {
            $attributes['client_image'] = $this->imageFile->path;
        } elseif (is_string($raw) && (str_starts_with($raw, 'uploads/') || str_starts_with($raw, 'uploads\\'))) {
            $attributes['client_image'] = $raw;
        } else {
            $attributes['client_image'] = null;
        }
        return $attributes;
    }
}
