<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Registration;
use Illuminate\Http\Request;

class RegistrationController extends Controller
{
    public function index()
    {
        return response()->json(Registration::with('imageFile')->latest()->get());
    }

    public function show($slug)
    {
        $registration = Registration::with('imageFile')->where('slug', $slug)->firstOrFail();
        return response()->json($registration);
    }
}
