<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function index()
    {
        $blogs = Blog::with(['image:id,path', 'authorImage:id,path'])
            ->where('status', 'active')
            ->select('id', 'title', 'slug', 'short_description', 'image_id', 'author_name', 'author_image_id', 'status', 'created_at')
            ->latest()
            ->paginate(10);

        return response()->json([
            'status' => 'success',
            'data' => $blogs
        ]);
    }

    public function show($slug)
    {
        $blog = Blog::where('slug', $slug)
            ->with(['image', 'authorImage'])
            ->firstOrFail();

        return response()->json([
            'status' => 'success',
            'data' => $blog
        ]);
    }
}
