<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\ContactMessage;
use Illuminate\Http\Request;

class PageCmsController extends Controller
{
    public function about()
    {
        $about_hero = Setting::where('key', 'about_hero')->first();
        $about_main = Setting::where('key', 'about_main')->first();
        
        $hero = $about_hero ? json_decode($about_hero->value) : (object)[
            'image' => '', 'heading' => '', 'paragraph' => ''
        ];
        $main = $about_main ? json_decode($about_main->value) : (object)[
            'heading' => '', 'description' => '', 'quote' => '',
            'btn_text' => '', 'btn_url' => '', 'image' => '',
            'tag_icon' => '', 'tag_heading' => '', 'tag_paragraph' => '',
            'bottom_tag' => ''
        ];

        return view('admin.pages.about', compact('hero', 'main'));
    }

    public function updateAbout(Request $request)
    {
        Setting::updateOrCreate(
            ['key' => 'about_hero'],
            ['value' => json_encode($request->hero)]
        );

        Setting::updateOrCreate(
            ['key' => 'about_main'],
            ['value' => json_encode($request->main)]
        );

        return back()->with('success', 'About Us page updated successfully.');
    }

    public function footer()
    {
        $footer_setting = Setting::where('key', 'footer')->first();
        $footer = $footer_setting ? json_decode($footer_setting->value) : (object)[
            'logo' => '', 'paragraph' => '', 'address' => '',
            'phone' => '', 'email' => '', 'tag_icon' => '',
            'tag_name' => '', 'tag_text' => ''
        ];

        return view('admin.pages.footer', compact('footer'));
    }

    public function updateFooter(Request $request)
    {
        Setting::updateOrCreate(
            ['key' => 'footer'],
            ['value' => json_encode($request->footer)]
        );

        return back()->with('success', 'Footer updated successfully.');
    }

    public function contact()
    {
        $contact_info = Setting::where('key', 'contact_info')->first();
        $contact = $contact_info ? json_decode($contact_info->value) : (object)[
            'address' => '', 'phone' => '', 'toll_free' => '',
            'fax' => '', 'email' => ''
        ];

        return view('admin.pages.contact', compact('contact'));
    }

    public function updateContact(Request $request)
    {
        Setting::updateOrCreate(
            ['key' => 'contact_info'],
            ['value' => json_encode($request->contact)]
        );

        return back()->with('success', 'Contact info updated successfully.');
    }

    public function messages()
    {
        $messages = ContactMessage::latest()->paginate(10);
        return view('admin.contact.messages', compact('messages'));
    }

    public function whyChooseUs()
    {
        $setting = Setting::where('key', 'why_choose_us_section')->first();
        $section = $setting ? json_decode($setting->value) : (object)[
            'heading' => '', 'paragraph' => '', 'image' => '',
            'btn_text' => '', 'btn_url' => ''
        ];

        return view('admin.pages.why-choose-us', compact('section'));
    }

    public function updateWhyChooseUs(Request $request)
    {
        Setting::updateOrCreate(
            ['key' => 'why_choose_us_section'],
            ['value' => json_encode($request->section)]
        );

        return back()->with('success', 'Why Choose Us section updated successfully.');
    }

    public function homeHero()
    {
        $setting = Setting::where('key', 'home_hero')->first();
        $hero = $setting ? json_decode($setting->value) : (object)[
            'bg_image' => '', 'tag' => '', 'heading' => '', 'paragraph' => '',
            'btn1_text' => '', 'btn1_url' => '', 'btn2_text' => '', 'btn2_url' => '',
            'bottom_tags' => [
                (object)['icon' => '', 'name' => ''],
                (object)['icon' => '', 'name' => ''],
                (object)['icon' => '', 'name' => ''],
                (object)['icon' => '', 'name' => ''],
            ]
        ];

        return view('admin.pages.home-hero', compact('hero'));
    }

    public function updateHomeHero(Request $request)
    {
        Setting::updateOrCreate(
            ['key' => 'home_hero'],
            ['value' => json_encode($request->hero)]
        );

        return back()->with('success', 'Home Hero section updated successfully.');
    }

    public function homeBanner()
    {
        $setting = Setting::where('key', 'home_banner')->first();
        $banner = $setting ? json_decode($setting->value) : (object)[
            'heading' => '', 'paragraph' => '',
            'btn1_text' => '', 'btn2_text' => ''
        ];

        return view('admin.pages.home-banner', compact('banner'));
    }

    public function updateHomeBanner(Request $request)
    {
        Setting::updateOrCreate(
            ['key' => 'home_banner'],
            ['value' => json_encode($request->banner)]
        );

        return back()->with('success', 'Home Banner section updated successfully.');
    }
}
